<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEscortTable extends Migration {

	public function up()
	{
		Schema::create('escort', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->tinyInteger('gender')->default('1');
			$table->string('phone_no')->nullable();
			$table->string('whatsapp_no')->nullable();
			$table->text('about_me')->nullable();
			$table->string('nationality')->nullable();
			$table->string('location')->nullable();
			$table->string('eyes')->nullable();
			$table->string('hair_length')->nullable();
			$table->string('hair_color')->nullable();
			$table->string('height')->nullable();
			$table->string('weight')->nullable();
			$table->string('color')->nullable();
			$table->string('look_like')->nullable();
			$table->integer('agency_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('escort');
	}
}