<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->text('body');
			$table->text('excerpt');
			$table->string('slug');
			$table->string('post_type');
			$table->boolean('approved');
			$table->timestamp('publish_date');
			$table->boolean('is_approved');
			$table->integer('user_id')->unsigned();
			$table->integer('tenant_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}