<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKnowledgeBaseTable extends Migration {

	public function up()
	{
		Schema::create('knowledge_base', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->integer('user_id')->unsigned();
			$table->string('content_type')->default('About');
			$table->text('body');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('knowledge_base');
	}
}