<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBadgesTable extends Migration {

	public function up()
	{
		Schema::create('badges', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 150);
			$table->string('slug', 100);
			$table->string('description', 255);
			$table->integer('min_value');
			$table->integer('max_value');
			$table->enum('aplies_for', array('views', 'comments', 'posts'));
			$table->string('icon_url', 50);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('badges');
	}
}