<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserVisitsTable extends Migration {

	public function up()
	{
		Schema::create('user_visits', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('page_id');
			$table->enum('page_type', array('post', 'category', 'tag', 'user'));
			$table->integer('user_id');
			$table->integer('count');
		});
	}

	public function down()
	{
		Schema::drop('user_visits');
	}
}