<?php

namespace shop.Discount_Episode;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discount_Episode extends Model 
{

    protected $table = 'Discount_Episode';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'EpisodeId', 'DiscountId', 'created_at');

    public function discounts()
    {
        return $this->belongsToMany('Episodes');
    }

    public function episodes()
    {
        return $this->belongsToMany('Discounts');
    }

}