<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('Comments', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->integer('Commentable_Id')->unsigned();
			$table->string('Commentable_Type');
			$table->string('Message', 4000);
			$table->integer('ParentId')->unsigned();
			$table->integer('EpisodeId')->unsigned();
			$table->timestamps();
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Comments');
	}
}