<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlidesTable extends Migration {

	public function up()
	{
		Schema::create('Slides', function(Blueprint $table) {
			$table->increments('Id', true);
			$table->string('Image');
			$table->string('Text')->nullable();
			$table->integer('SliderId')->unsigned();
			$table->timestamp('created_at');
			$table->timestamp('updated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Slides');
	}
}