<?php

namespace App/Models;

class Country extends Eloquent {

	protected $table = 'countries';
	public $timestamps = true;
	protected $fillable = array('name', 'code');

	public function users()
	{
		return $this->hasMany('App\Models\User', 'country_id');
	}

	public function cities()
	{
		return $this->hasMany('App/Models\City', 'country_id');
	}

	public function governrates()
	{
		return $this->hasMany('App/Models\Governrate', 'country_id');
	}

}