<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function roles()
    {
        return $this->belongsToMany('Role');
    }

    public function loginAttempts()
    {
        return $this->hasMany('LoginAttempt');
    }

    public function profile()
    {
        return $this->hasOne('Profiel');
    }

    public function searches()
    {
        return $this->hasMany('Search');
    }

}