<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class File extends Model 
{

    protected $table = 'files';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'path', 'extension', 'content', 'preview', 'keywords', 'author', 'copyright');
    protected $visible = array('name', 'path', 'extension', 'content', 'preview', 'keywords', 'author', 'copyright');

    public function categories()
    {
        return $this->belongsToMany('App\Category', 'categories_files');
    }

    public function folders()
    {
        return $this->belongsToMany('App\Folder', 'files_folders');
    }

    public function user()
    {
        return $this->hasMany('App\User', 'picture');
    }

    public function author()
    {
        return $this->belongsTo('App\User', 'id');
    }

    public function groups()
    {
        return $this->belongsToMany('App\Group', 'files_groups')->withPivot('sent');
    }

}