<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('picture')->references('id')->on('files')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('author')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('folders', function(Blueprint $table) {
			$table->foreign('thumbnail')->references('id')->on('files')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('folders', function(Blueprint $table) {
			$table->foreign('dependency')->references('id')->on('folders')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('groups_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('groups_users', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events_groups', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events_groups', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories_files', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories_files', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files_folders', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files_folders', function(Blueprint $table) {
			$table->foreign('folder_id')->references('id')->on('folders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('folders_groups', function(Blueprint $table) {
			$table->foreign('folder_id')->references('id')->on('folders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('folders_groups', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('folders_users', function(Blueprint $table) {
			$table->foreign('folder_id')->references('id')->on('folders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('folders_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories_events', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories_events', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files_groups', function(Blueprint $table) {
			$table->foreign('file_id')->references('id')->on('files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('files_groups', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_picture_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_author_foreign');
		});
		Schema::table('folders', function(Blueprint $table) {
			$table->dropForeign('folders_thumbnail_foreign');
		});
		Schema::table('folders', function(Blueprint $table) {
			$table->dropForeign('folders_dependency_foreign');
		});
		Schema::table('groups_users', function(Blueprint $table) {
			$table->dropForeign('groups_users_user_id_foreign');
		});
		Schema::table('groups_users', function(Blueprint $table) {
			$table->dropForeign('groups_users_group_id_foreign');
		});
		Schema::table('events_groups', function(Blueprint $table) {
			$table->dropForeign('events_groups_event_id_foreign');
		});
		Schema::table('events_groups', function(Blueprint $table) {
			$table->dropForeign('events_groups_group_id_foreign');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->dropForeign('events_users_user_id_foreign');
		});
		Schema::table('events_users', function(Blueprint $table) {
			$table->dropForeign('events_users_event_id_foreign');
		});
		Schema::table('categories_files', function(Blueprint $table) {
			$table->dropForeign('categories_files_category_id_foreign');
		});
		Schema::table('categories_files', function(Blueprint $table) {
			$table->dropForeign('categories_files_file_id_foreign');
		});
		Schema::table('files_folders', function(Blueprint $table) {
			$table->dropForeign('files_folders_file_id_foreign');
		});
		Schema::table('files_folders', function(Blueprint $table) {
			$table->dropForeign('files_folders_folder_id_foreign');
		});
		Schema::table('folders_groups', function(Blueprint $table) {
			$table->dropForeign('folders_groups_folder_id_foreign');
		});
		Schema::table('folders_groups', function(Blueprint $table) {
			$table->dropForeign('folders_groups_group_id_foreign');
		});
		Schema::table('folders_users', function(Blueprint $table) {
			$table->dropForeign('folders_users_folder_id_foreign');
		});
		Schema::table('folders_users', function(Blueprint $table) {
			$table->dropForeign('folders_users_user_id_foreign');
		});
		Schema::table('categories_events', function(Blueprint $table) {
			$table->dropForeign('categories_events_category_id_foreign');
		});
		Schema::table('categories_events', function(Blueprint $table) {
			$table->dropForeign('categories_events_event_id_foreign');
		});
		Schema::table('files_groups', function(Blueprint $table) {
			$table->dropForeign('files_groups_file_id_foreign');
		});
		Schema::table('files_groups', function(Blueprint $table) {
			$table->dropForeign('files_groups_group_id_foreign');
		});
	}
}