<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->timestamp('email_verified_at')->nullable();
			$table->softDeletes();
			$table->string('password', 100);
			$table->string('firstname', 100)->nullable();
			$table->enum('gender', array('Male', 'Female', 'Other'))->nullable();
			$table->string('lastname', 255)->nullable();
			$table->text('address')->nullable();
			$table->text('sub_address')->nullable();
			$table->string('zip_code', 15)->nullable();
			$table->string('city', 100)->nullable();
			$table->string('cedex', 15)->nullable();
			$table->string('phone_number', 20)->nullable();
			$table->integer('picture')->unsigned()->nullable();
			$table->string('email', 100)->unique()->nullable();
			$table->string('role', 255)->nullable();
			$table->text('url')->nullable();
			$table->string('job', 255)->nullable();
			$table->text('description')->nullable();
			$table->string('locale', 255)->nullable();
			$table->rememberToken();
			$table->string('organism', 255)->nullable();
			$table->boolean('stopMail')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}