<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'start', 'end', 'place', 'importance');
	protected $visible = array('title', 'start', 'end', 'place', 'importance');

	public function users()
	{
		return $this->belongsToMany('App\User', 'groups_users');
	}

	public function groups()
	{
		return $this->belongsToMany('App\Group', 'events_groups');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Category', 'categories_events');
	}

}