<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Folder extends Eloquent {

	protected $table = 'folders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'thumbnail', 'dependency', 'shared', 'access');
	protected $visible = array('name', 'description', 'thumbnail', 'dependency', 'shared', 'access');

	public function files()
	{
		return $this->belongsToMany('App\File', 'files_folders');
	}

	public function thumbnail()
	{
		return $this->belongsTo('App\File', 'thumbnail');
	}

	public function groups()
	{
		return $this->belongsToMany('App\Group', 'folders_groups');
	}

	public function users()
	{
		return $this->belongsToMany('App\User', 'folders_users');
	}

}