<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');
	protected $visible = array('name');

	public function users()
	{
		return $this->belongsToMany('App\User', 'groups_users');
	}

	public function events()
	{
		return $this->belongsToMany('App\Event', 'events_groups');
	}

	public function folders()
	{
		return $this->belongsToMany('App\Folder', 'folders_groups');
	}

	public function files()
	{
		return $this->hasMany('App\File', 'files_groups')->withPivot('sent');
	}

}