<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentsTable extends Migration {

	public function up()
	{
		Schema::create('contents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->unique();
			$table->text('content');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('title', 255);
		});
	}

	public function down()
	{
		Schema::drop('contents');
	}
}