<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('start', 'end', 'name', 'user_id', 'validated', 'article', 'team', 'team_id');

	public function team()
	{
		return $this->belongsTo('App\Team');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function pictures()
	{
		return $this->hasMany('App\Picture');
	}

}