<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentRecordsTable extends Migration {

	public function up()
	{
		Schema::create('content_records', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->index();
			$table->text('content');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('title', 255);
		});
	}

	public function down()
	{
		Schema::drop('content_records');
	}
}