<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobAdvert extends Model 
{

    protected $table = 'job_advert';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nb_of_candidates', 'trainee_accepted', 'start_date', 'end_date', 'wage', 'title', 'description', 'file', 'url', 'slug');

    public function user()
    {
        return $this->belongsTo('\User');
    }

    public function certificatesGraduations()
    {
        return $this->belongsToMany('\Graduation');
    }

}