<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->text('content');
			$table->integer('user_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('slug', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}