<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CourseAdvert extends Eloquent {

	protected $table = 'course_advert';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'type', 'single_day', 'start_date', 'end_date', 'address', 'zipcode', 'city', 'price', 'description', 'contact', 'email', 'url', 'slug');

	public function user()
	{
		return $this->belongsTo('\User');
	}

}