<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'post';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'content', 'slug');

	public function category()
	{
		return $this->belongsTo('\Category', 'category_id');
	}

	public function tags()
	{
		return $this->belongsToMany('\Tag');
	}

	public function notations()
	{
		return $this->hasMany('\Notation');
	}

}