<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('email');

	public function notations()
	{
		return $this->hasMany('\Notation');
	}

	public function jobAdverts()
	{
		return $this->hasMany('\JobAdvert');
	}

	public function courseAdverts()
	{
		return $this->hasMany('\CourseAdvert');
	}

	public function cvs()
	{
		return $this->hasMany('\Cv');
	}

	public function addresses()
	{
		return $this->hasMany('\Address');
	}

}