<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseAdvertTable extends Migration {

	public function up()
	{
		Schema::create('course_advert', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('type');
			$table->integer('graduation_id')->unsigned()->nullable();
			$table->integer('formation_id')->unsigned()->nullable();
			$table->boolean('single_day');
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->integer('department_id')->unsigned();
			$table->string('address');
			$table->string('zipcode');
			$table->string('city');
			$table->float('price');
			$table->string('description');
			$table->string('contact');
			$table->string('email');
			$table->string('url');
			$table->string('slug');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('course_advert');
	}
}