<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CourseAdvert extends Model 
{

    protected $table = 'course_advert';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'type', 'single_day', 'start_date', 'end_date', 'address', 'zipcode', 'city', 'price', 'description', 'contact', 'email', 'url', 'slug');

    public function user()
    {
        return $this->belongsTo('\User');
    }

}