<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartItemsTable extends Migration {

	public function up()
	{
		Schema::create('cart_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('cart_id')->unsigned()->index();
			$table->uuid('uuid')->unique();
			$table->integer('variant_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->integer('seller_id')->unsigned()->nullable()->index();
			$table->float('quantity')->index();
			$table->text('remarks')->nullable();
			$table->integer('address_id')->unsigned()->nullable()->index();
			$table->boolean('is_selected')->index()->default(true);
			$table->json('data')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('cart_items');
	}
}