<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->uuid('uuid')->unique();
			$table->text('body');
			$table->bigInteger('commentable_id');
			$table->string('commentable_type');
			$table->datetime('read_at')->nullable();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}