<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDescriptionPivotsTable extends Migration {

	public function up()
	{
		Schema::create('description_pivots', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('product_id')->unsigned()->index();
			$table->string('slug', 63)->index();
			$table->text('description');
			$table->integer('index')->unsigned()->nullable()->index();
			$table->boolean('is_enabled')->index()->default(true);
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('description_pivots');
	}
}