<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('order_id')->unsigned()->index();
			$table->uuid('uuid')->unique();
			$table->integer('variant_id')->unsigned()->index();
			$table->integer('product_id')->unsigned()->index();
			$table->mediumText('remarks');
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}