<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductParametersTable extends Migration {

	public function up()
	{
		Schema::create('product_parameters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->string('slug', 63)->index();
			$table->text('description')->nullable();
			$table->json('values');
			$table->integer('index')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('product_parameters');
	}
}