<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVoucherPivotsTable extends Migration {

	public function up()
	{
		Schema::create('voucher_pivots', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('voucher_id')->unsigned()->index();
			$table->string('ref_type', 127)->index();
			$table->string('ref_table', 63)->index();
			$table->integer('ref_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('voucher_pivots');
	}
}