<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlashsaleItemsTable extends Migration {

	public function up()
	{
		Schema::create('flashsale_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->string('ref_id');
			$table->string('ref_type');
			$table->string('ref_table');
			$table->integer('price_id')->unsigned();
			$table->integer('stock_total')->unsigned();
			$table->integer('stock_buffered')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('flashsale_items');
	}
}