<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->text('content');
			$table->morphs('ref');
			$table->integer('user_id')->unsigned();
			$table->timestamp('hidden_at')->nullable();
			$table->boolean('is_trusted')->default(false);
			$table->timestamps();
			$table->integer('like_total')->unsigned()->default('0');
			$table->integer('dislike_total')->unsigned()->default('0');
			$table->decimal('average_rating')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}