<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePricesTable extends Migration {

	public function up()
	{
		Schema::create('prices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid')->unique();
			$table->integer('variant_id')->unsigned()->index();
			$table->char('currency_code', 3)->index();
			$table->decimal('amount', 16,2);
			$table->float('min_quantity')->nullable();
			$table->float('max_quantity')->nullable();
			$table->boolean('is_default')->index()->default(false);
			$table->boolean('is_enabled')->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('prices');
	}
}