<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkinDiaryProductsTable extends Migration {

	public function up()
	{
		Schema::create('skin_diary_products', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('skin_diary_id')->unsigned();
			$table->uuid('uuid')->unique();
			$table->string('title');
			$table->string('brand');
			$table->string('url')->nullable();
			$table->text('description')->nullable();
			$table->nullableMorphs('ref');
			$table->string('ref_table')->nullable();
			$table->tinyInteger('rating')->unsigned()->default('0');
			$table->string('step_name')->default('Skin Care Routine');
			$table->tinyInteger('index')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('skin_diary_products');
	}
}