<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBadgesTable extends Migration {

	public function up()
	{
		Schema::create('badges', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->text('description')->nullable();
			$table->string('icon')->nullable();
			$table->tinyInteger('level')->unsigned()->default('1');
			$table->timestamps();
			$table->integer('point_min')->unsigned();
			$table->integer('point_maintain')->unsigned();
			$table->integer('purchase_min')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('badges');
	}
}