<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommerceEventsTable extends Migration {

	public function up()
	{
		Schema::create('commerce_events', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('event_type');
			$table->nullableMorphs('ref');
			$table->string('ref_table')->nullable();
			$table->json('custom_properties')->nullable();
			$table->string('user_agent')->nullable();
			$table->ipAddress('source_ip');
			$table->string('url')->nullable();
			$table->string('referrer')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('commerce_events');
	}
}