<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserRewardsTable extends Migration {

	public function up()
	{
		Schema::create('user_rewards', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->integer('reward_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->datetime('valid_from')->nullable();
			$table->datetime('expired_at')->nullable();
			$table->datetime('redeemed_at');
		});
	}

	public function down()
	{
		Schema::drop('user_rewards');
	}
}