<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('Type_service_id')->unsigned();
			$table->string('ville_depart');
			$table->string('ville_arriver');
			$table->bigInteger('fornisseur_id')->unsigned();
			$table->string('note', 300);
			$table->float('prix');
			$table->boolean('is_paid');
			$table->string('designation');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}