<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('uuid');
			$table->string('name');
			$table->longText('content');
			$table->boolean('status');
			$table->integer('visit_counts');
			$table->integer('template_id')->unsigned()->index();
			$table->bigInteger('customer_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}