<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepensesTable extends Migration {

	public function up()
	{
		Schema::create('depenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_entreprise')->unsigned()->nullable();
			$table->integer('id_motifDepense')->unsigned()->nullable();
			$table->integer('id_utilisateur')->unsigned()->nullable();
			$table->integer('id_vague')->unsigned()->nullable();
			$table->integer('id_passage_veterinaire')->unsigned()->nullable();
			$table->integer('id_mouvement_stock')->unsigned()->nullable();
			$table->integer('id_typeCaisse')->unsigned()->nullable();
			$table->string('amortissable', 10)->nullable()->default('0');
			$table->integer('prix')->nullable();
			$table->timestamp('date')->nullable();
			$table->integer('dureeAmortissement')->nullable();
			$table->timestamp('dateDebutAmortissement')->nullable();
			$table->string('motif', 255)->nullable();
			$table->text('description')->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('depenses');
	}
}