<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMouvementsEffectifsTable extends Migration {

	public function up()
	{
		Schema::create('mouvements_effectifs', function(Blueprint $table) {
			$table->timestamps();
			$table->timestamp('date')->nullable();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_utilisateur')->unsigned()->nullable();
			$table->increments('id');
			$table->integer('id_vague')->unsigned()->nullable();
			$table->integer('id_typeCaisse')->unsigned()->nullable();
			$table->integer('effectif')->nullable();
			$table->string('prix', 255)->nullable();
			$table->string('motif', 255)->nullable();
			$table->text('commentaire')->nullable();
			$table->string('type', 255)->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('mouvements_effectifs');
	}
}