<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVersementsTable extends Migration {

	public function up()
	{
		Schema::create('versements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_entreprise')->unsigned()->nullable();
			$table->integer('id_nm_admin')->unsigned()->nullable();
			$table->timestamp('dateDebut')->nullable();
			$table->timestamp('dateFin')->nullable();
			$table->integer('nombreUtilisateur')->nullable();
			$table->integer('nombreJour')->nullable();
			$table->integer('nombreVague')->nullable();
			$table->integer('montant')->nullable();
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('versements');
	}
}