<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('entreprises', function(Blueprint $table) {
			$table->foreign('id_NMadmin')->references('id')->on('nm_admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilisateurs', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('utilisateurs_niveau4', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('especes', function(Blueprint $table) {
			$table->foreign('id_espece')->references('id')->on('especes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('especes', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vagues', function(Blueprint $table) {
			$table->foreign('id_espece')->references('id')->on('especes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mouvements_effectifs', function(Blueprint $table) {
			$table->foreign('id_utilisateur')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mouvements_effectifs', function(Blueprint $table) {
			$table->foreign('id_vague')->references('id')->on('vagues')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mouvements_effectifs', function(Blueprint $table) {
			$table->foreign('id_typeCaisse')->references('id')->on('types_caisses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aliments', function(Blueprint $table) {
			$table->foreign('id_unite')->references('id')->on('unites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aliments', function(Blueprint $table) {
			$table->foreign('unite_sortie')->references('id')->on('unites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mouvements_stocks', function(Blueprint $table) {
			$table->foreign('id_depense')->references('id')->on('depenses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mouvements_stocks', function(Blueprint $table) {
			$table->foreign('id_aliment')->references('id')->on('aliments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mouvements_stocks', function(Blueprint $table) {
			$table->foreign('id_utilisateur')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equivalences_unites', function(Blueprint $table) {
			$table->foreign('id_uniteDepart')->references('id')->on('unites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equivalences_unites', function(Blueprint $table) {
			$table->foreign('id_uniteArrive')->references('id')->on('unites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aliments_vagues', function(Blueprint $table) {
			$table->foreign('id_vague')->references('id')->on('vagues')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('aliments_vagues', function(Blueprint $table) {
			$table->foreign('id_aliment')->references('id')->on('aliments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_motifDepense')->references('id')->on('motifs_depenses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_utilisateur')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_vague')->references('id')->on('vagues')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_passage_veterinaire')->references('id')->on('passages_veterinaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_mouvement_stock')->references('id')->on('mouvements_stocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->foreign('id_typeCaisse')->references('id')->on('types_caisses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('creances_dettes_fonds', function(Blueprint $table) {
			$table->foreign('id_utilisateurNiveau4')->references('id')->on('utilisateurs_niveau4')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('creances_dettes_fonds', function(Blueprint $table) {
			$table->foreign('id_utilisateur')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('creances_dettes_fonds', function(Blueprint $table) {
			$table->foreign('id_typeCaisse')->references('id')->on('types_caisses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('montants_types_caisses', function(Blueprint $table) {
			$table->foreign('id_typeCaisse')->references('id')->on('types_caisses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('montants_types_caisses', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mails_sms', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mails_sms', function(Blueprint $table) {
			$table->foreign('id_utilisateur')->references('id')->on('utilisateurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('motifs_depenses', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passages_veterinaires', function(Blueprint $table) {
			$table->foreign('id_utilisateurNiveau4')->references('id')->on('utilisateurs_niveau4')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passages_veterinaires_vagues', function(Blueprint $table) {
			$table->foreign('id_passage_veterinaire')->references('id')->on('passages_veterinaires')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passages_veterinaires_vagues', function(Blueprint $table) {
			$table->foreign('id_vague')->references('id')->on('vagues')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('versements', function(Blueprint $table) {
			$table->foreign('id_entreprise')->references('id')->on('entreprises')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('versements', function(Blueprint $table) {
			$table->foreign('id_nm_admin')->references('id')->on('nm_admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('entreprises', function(Blueprint $table) {
			$table->dropForeign('entreprises_id_NMadmin_foreign');
		});
		Schema::table('utilisateurs', function(Blueprint $table) {
			$table->dropForeign('utilisateurs_id_entreprise_foreign');
		});
		Schema::table('utilisateurs_niveau4', function(Blueprint $table) {
			$table->dropForeign('utilisateurs_niveau4_id_entreprise_foreign');
		});
		Schema::table('especes', function(Blueprint $table) {
			$table->dropForeign('especes_id_espece_foreign');
		});
		Schema::table('especes', function(Blueprint $table) {
			$table->dropForeign('especes_id_entreprise_foreign');
		});
		Schema::table('vagues', function(Blueprint $table) {
			$table->dropForeign('vagues_id_espece_foreign');
		});
		Schema::table('mouvements_effectifs', function(Blueprint $table) {
			$table->dropForeign('mouvements_effectifs_id_utilisateur_foreign');
		});
		Schema::table('mouvements_effectifs', function(Blueprint $table) {
			$table->dropForeign('mouvements_effectifs_id_vague_foreign');
		});
		Schema::table('mouvements_effectifs', function(Blueprint $table) {
			$table->dropForeign('mouvements_effectifs_id_typeCaisse_foreign');
		});
		Schema::table('aliments', function(Blueprint $table) {
			$table->dropForeign('aliments_id_unite_foreign');
		});
		Schema::table('aliments', function(Blueprint $table) {
			$table->dropForeign('aliments_unite_sortie_foreign');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->dropForeign('unites_id_entreprise_foreign');
		});
		Schema::table('mouvements_stocks', function(Blueprint $table) {
			$table->dropForeign('mouvements_stocks_id_depense_foreign');
		});
		Schema::table('mouvements_stocks', function(Blueprint $table) {
			$table->dropForeign('mouvements_stocks_id_aliment_foreign');
		});
		Schema::table('mouvements_stocks', function(Blueprint $table) {
			$table->dropForeign('mouvements_stocks_id_utilisateur_foreign');
		});
		Schema::table('equivalences_unites', function(Blueprint $table) {
			$table->dropForeign('equivalences_unites_id_uniteDepart_foreign');
		});
		Schema::table('equivalences_unites', function(Blueprint $table) {
			$table->dropForeign('equivalences_unites_id_uniteArrive_foreign');
		});
		Schema::table('aliments_vagues', function(Blueprint $table) {
			$table->dropForeign('aliments_vagues_id_vague_foreign');
		});
		Schema::table('aliments_vagues', function(Blueprint $table) {
			$table->dropForeign('aliments_vagues_id_aliment_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_entreprise_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_motifDepense_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_utilisateur_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_vague_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_passage_veterinaire_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_mouvement_stock_foreign');
		});
		Schema::table('depenses', function(Blueprint $table) {
			$table->dropForeign('depenses_id_typeCaisse_foreign');
		});
		Schema::table('creances_dettes_fonds', function(Blueprint $table) {
			$table->dropForeign('creances_dettes_fonds_id_utilisateurNiveau4_foreign');
		});
		Schema::table('creances_dettes_fonds', function(Blueprint $table) {
			$table->dropForeign('creances_dettes_fonds_id_utilisateur_foreign');
		});
		Schema::table('creances_dettes_fonds', function(Blueprint $table) {
			$table->dropForeign('creances_dettes_fonds_id_typeCaisse_foreign');
		});
		Schema::table('montants_types_caisses', function(Blueprint $table) {
			$table->dropForeign('montants_types_caisses_id_typeCaisse_foreign');
		});
		Schema::table('montants_types_caisses', function(Blueprint $table) {
			$table->dropForeign('montants_types_caisses_id_entreprise_foreign');
		});
		Schema::table('mails_sms', function(Blueprint $table) {
			$table->dropForeign('mails_sms_id_entreprise_foreign');
		});
		Schema::table('mails_sms', function(Blueprint $table) {
			$table->dropForeign('mails_sms_id_utilisateur_foreign');
		});
		Schema::table('motifs_depenses', function(Blueprint $table) {
			$table->dropForeign('motifs_depenses_id_entreprise_foreign');
		});
		Schema::table('passages_veterinaires', function(Blueprint $table) {
			$table->dropForeign('passages_veterinaires_id_utilisateurNiveau4_foreign');
		});
		Schema::table('passages_veterinaires_vagues', function(Blueprint $table) {
			$table->dropForeign('passages_veterinaires_vagues_id_passage_veterinaire_foreign');
		});
		Schema::table('passages_veterinaires_vagues', function(Blueprint $table) {
			$table->dropForeign('passages_veterinaires_vagues_id_vague_foreign');
		});
		Schema::table('versements', function(Blueprint $table) {
			$table->dropForeign('versements_id_entreprise_foreign');
		});
		Schema::table('versements', function(Blueprint $table) {
			$table->dropForeign('versements_id_nm_admin_foreign');
		});
	}
}