<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Depense extends Eloquent {

	protected $table = 'depenses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_entreprise', 'id_motifDepense', 'id_utilisateur', 'id_vague', 'id_passage_veterinaire', 'id_mouvement_stock', 'id_typeCaisse', 'amortissable', 'prix', 'date', 'dureeAmortissement', 'dateDebutAmortissement', 'motif', 'description', 'statut');
	protected $visible = array('slug', 'id_entreprise', 'id_motifDepense', 'id_utilisateur', 'id_vague', 'id_passage_veterinaire', 'id_mouvement_stock', 'id_typeCaisse', 'amortissable', 'prix', 'date', 'dureeAmortissement', 'dateDebutAmortissement', 'motif', 'description', 'statut');

	public function entreprise()
	{
		return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
	}

	public function utilisateur()
	{
		return $this->belongsTo('App\Models\Utilisateur', 'id_utilisateur');
	}

	public function motifDepense()
	{
		return $this->belongsTo('App\Models\MotifDepense', 'id_motifDepense');
	}

	public function vague()
	{
		return $this->belongsTo('App\Models\Vague', 'id_vague');
	}

	public function typeCaisse()
	{
		return $this->belongsTo('App\Models\TypeCaisse', 'id_typeCaisse');
	}

	public function passageVeterinaire()
	{
		return $this->belongsTo('App\Models\PassageVeterinaire', 'id_passage_veterinaire');
	}

	public function mouvementStock()
	{
		return $this->belongsTo('App\Models\MouvementStock', 'id_mouvement_stock');
	}

}