<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MontantTypeCaisse extends Eloquent {

	protected $table = 'montants_types_caisses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'id_typeCaisse', 'id_entreprise', 'montant', 'statut');
	protected $visible = array('slug', 'id_typeCaisse', 'id_entreprise', 'montant');

	public function entreprise()
	{
		return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
	}

	public function typeCaisse()
	{
		return $this->belongsTo('App\Models\TypeCaisse', 'id_typeCaisse');
	}

}