<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MouvementStock extends Eloquent {

	protected $table = 'mouvements_stocks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'slug', 'id_depense', 'id_aliment', 'id_utilisateur', 'effectif', 'motif', 'commentaire', 'origine', 'prix', 'type', 'equivalence_fait', 'statut');
	protected $visible = array('date', 'slug', 'id_depense', 'id_aliment', 'id_utilisateur', 'effectif', 'motif', 'commentaire', 'origine', 'prix', 'type', 'equivalence_fait', 'statut');

	public function aliment()
	{
		return $this->belongsTo('App\Models\Aliment', 'id_aliment');
	}

	public function utilisateur()
	{
		return $this->belongsTo('App\Models\Utilisateur', 'id_utilisateur');
	}

	public function unite()
	{
		return $this->belongsTo('App\Models\Unite', 'id_unite');
	}

	public function depense()
	{
		return $this->hasMany('App\Models\Depense', 'id_mouvement_stock');
	}

}