<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVaguesTable extends Migration {

	public function up()
	{
		Schema::create('vagues', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->string('libelle', 255)->nullable();
			$table->integer('id_espece')->unsigned()->nullable();
			$table->integer('effectif')->unsigned()->nullable();
			$table->integer('effectiDepart')->nullable();
			$table->string('statut', 10)->nullable()->default('0');
			$table->string('description', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vagues');
	}
}