<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('center_id')->unsigned()->index();
			$table->integer('customer_id')->unsigned()->nullable()->index();
			$table->string('description', 200)->nullable();
			$table->string('status_id')->index()->default('N');
			$table->datetime('expires_at')->nullable()->index();
			$table->tinyInteger('alert_expiration')->index()->default('0');
			$table->datetime('date_from')->nullable()->index();
			$table->datetime('date_to')->nullable()->index();
			$table->integer('nbr_adults')->nullable();
			$table->integer('nbr_children')->nullable();
			$table->integer('nbr_groups')->default('1');
			$table->decimal('discount_pct')->default('0');
			$table->decimal('discount_amount')->default('0');
			$table->integer('meal_provision_id')->unsigned()->index();
			$table->string('code', 50)->nullable()->index();
			$table->string('password', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}